/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.fund;

import com.fshows.shande.sdk.response.fund.item.ShandeTransferParamItemResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 分账（批量转账）响应结果
 *
 * @author
 * @version ShandeFundAllocationsOutResponse.java, v 0.1 2022-12-06 10:11:52
 */
@Data
public class ShandeFundAllocationsOutResponse implements Serializable {

    private static final long serialVersionUID = -2213838555364103160L;


    /**
     * 校验类型
     * 0、关闭校验1、免密2、密码3、密码+短信4、密码+短信+人脸
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "verifyType长度不能超过1")
    private String verifyType;

    /**
     * 验证URl
     * 1、当verifyType值为2或3时返回2、后面的数据当verifyType值为0或1时返回
     *
     * (特殊必填)
     */
    @Length(max = 256, message = "verifyUrl长度不能超过256")
    private String verifyUrl;

    /**
     * 分账订单系统订 单号
     * 由系统生成的唯一单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "allocationId长度不能超过19")
    private String allocationId;

    /**
     * 交易状态
     * succeeded: 成功processing: 处理中failed: 失败partially_succeeded:部分成功
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "status长度不能超过10")
    private String status;

    /**
     * 平台订单号
     * 平台的唯一请求单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

    /**
     * 创建时间
     * 格式: RFC3339
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 25, message = "createdAt长度不能超过25")
    private String createdAt;

    /**
     * 完成时间
     * 格式: RFC3339
     *
     * (特殊必填)
     */
    @Length(max = 25, message = "finishedAt长度不能超过25")
    private String finishedAt;

    /**
     * 付款电子账簿 ID
     * 付款用户的电子账簿ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "payBalanceAcctId长度不能超过19")
    private String payBalanceAcctId;

    /**
     * 转账明细
     *
     * transfer_results[*]
     * transfer_results[*][extra]
     * transfer_results[*][metadata]
     *
     * (必填)
     */
    @NotNull
    private List<ShandeTransferParamItemResponse> transferResults;

    /**
     * 备注
     * 备注信息
     *
     * (选填)
     */
    @Length(max = 255, message = "remark长度不能超过255")
    private String remark;

    /**
     * 扩展字段
     * 预留扩展字段交易涉及的商品信息，根据必传要求上 送，参考示例
     *
     * (特殊必填)
     */
    private Map<String,Object> extra;

    /**
     * 自定义参数
     * {"purpose":"123456"}
     *
     * (选填)
     */
    private Map<String,String> metadata;
}