/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.common;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 个人用户手机号验证响应结果
 *
 * @author
 * @version ShandePersonalValidationSmsResponse.java, v 0.1 2022-12-06 10:42:39
 */
@Data
public class ShandePersonalValidationSmsResponse implements Serializable {

    private static final long serialVersionUID = -2213838555318332301L;


    /**
     * 手机号
     * 绑定银行卡的手机号，11 位数字
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 11, message = "mobileNumber长度不能超过11")
    private String mobileNumber;

}