/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.response.books.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 *
 *
 * @author liluqing
 * @version ShandeBalanceTransactionsDataResponse.java, v 0.1 2022-12-06 11:56
 */
@Data
public class ShandeBalanceTransactionsDataResponse implements Serializable {

    private static final long serialVersionUID = -2213838555834578039L;

    /**
     * 流水ID
     *
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "balanceTxnId长度不能超过64")
    private String balanceTxnId;

    /**
     * 电子账簿 ID
     *
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 系统订单号
     * 由系统生成的唯一单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "tradeId长度不能超过19")
    private String tradeId;

    /**
     * 请求单号
     *
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

    /**
     * 交易类型
     * 交易类型，充值、消费、担保等参考：[交易类型字典
     *
     * (必填)
     */
    @NotNull
    private Integer tradeType;

    /**
     * 业务类型
     * 参考：[业务类型字典
     *
     * (必填)
     */
    @NotNull
    private Integer txnType;

    /**
     * 可提
     *
     *
     * (必填)
     */
    @NotNull
    private Integer settledAmount;

    /**
     * 在途金额
     *
     *
     * (必填)
     */
    @NotNull
    private Integer pendingAmount;

    /**
     * 不可用金额
     *
     *
     * (必填)
     */
    @NotNull
    private Integer expensingAmount;

    /**
     * 备注
     * 备注信息
     *
     * (选填)
     */
    @Length(max = 255, message = "remark长度不能超过255")
    private String remark;

    /**
     * 交易后可提现余额
     * 字段值为空时，表示交易后余额暂未更新，请稍后再查询
     *
     * (选填)
     */
    private Integer settledBalance;

    /**
     * 交易后在途余额
     * 字段值为空时，表示交易后余额暂未更新，请稍后再查询
     *
     * (选填)
     */
    private Integer pendingBalance;

    /**
     * 交易后不可用余额
     * 字段值为空时，表示交易后余额暂未更新，请稍后再查询
     *
     * (选填)
     */
    private Integer expensingBalance;

    /**
     * 原系统订单号
     * 交易类型为以下时展示:退款、退汇、担保确认
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "origTradeId长度不能超过19")
    private String origTradeId;

    /**
     * 原请求单号
     * 交易类型为以下时展示: 退款、退汇、担保确认
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "origOutOrderNo长度不能超过64")
    private String origOutOrderNo;

    /**
     * 交易成功时间
     * 成功或失败的时间格式: RFC3339
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "succeededAt长度不能超过32")
    private String succeededAt;
}