/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 联系人信息信息
 *
 * @author liluqing
 * @version ShandeIegalPersonIdCardRequest.java, v 0.1 2022-12-06 14:33
 */
@Data
public class ShandeContactIdCardRequest implements Serializable {

    private static final long serialVersionUID = -2213838555911708488L;

    /**
     * 联系人姓名
     *
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "name长度不能超过64")
    private String name;

    /**
     * 联系人证件类型
     * 枚举值：- 中国大陆居民-身份证- 其他国家或地区居民-护照- 中国香港居民–来往内地通行证- 中国澳门居民–来往内地通行证- 中国台湾居民–来往大陆通行证
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "type长度不能超过1")
    private String type;

    /**
     * 联系人身份证人像面照片
     * 1、请联系人的身份证人像面或其他证件类型的照片2、可上传 1 张图片，请填写通过[图片上传接口预先上传图片生成好的 media_id
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "copy长度不能超过255")
    private String copy;

    /**
     * 联系人证件国徽面照片
     * 1、请上传联系人身份件国徽面照片
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "national长度不能超过255")
    private String national;

    /**
     * 联系人身份证件号码
     *
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 18, message = "number长度不能超过18")
    private String number;

    /**
     * 联系人证件有效期
     * 1、若证件有效期为长期，到期时间请填写：长期 2、证件类型为身份证时填写起止日期并用逗号隔开，格式：1990-01-01，长期3、证件类型不为身份证时仅填写截止日期，格式：1990-01-01
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "validTime长度不能超过32")
    private String validTime;
}