/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.fund;

import com.fshows.shande.sdk.request.ShandeRequest;
import com.fshows.shande.sdk.request.fund.item.ShandeProductInfoItemRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Map;

/**
 * 支付充值入参
 *
 * @author
 * @version ShandeDepositsInRequest.java, v 0.1 2022-12-06 14:51:06
 */
@Data
public class ShandeDepositsInRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555818867717L;


    /**
     * 平台订单号
     * 1、平台的唯一请求单号2、要求 64 个字符内，只能是数字、大小写字母和_-
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

    /**
     * 总金额
     * 充值订单总金额，单位为分discount_amount存在时该字段必传
     *
     * (特殊必填)
     */
    private Integer totalAmount;

    /**
     * 支付金额
     * 单位为分，充值订单用户实际支付金额，不含平台优惠金额
     *
     * (必填)
     */
    @NotNull
    private Integer amount;

    /**
     * 平台优惠金额
     * 单位为分，平台用于营销补贴的金额
     *
     * (选填)
     */
    private Integer discountAmount;

    /**
     * 电子账簿 ID
     * 记账的电子账簿 ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 记账类型
     * 枚举值：充值消费
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "depositType长度不能超过1")
    private String depositType;

    /**
     * 支付类型
     * 支付通道类型，参照：支付类型编码
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "paymentType长度不能超过20")
    private String paymentType;

    /**
     * 支付通道订单号
     * 支付通道订单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "paymentTradeNo长度不能超过64")
    private String paymentTradeNo;

    /**
     * 支付成功时间
     * 支付通道返回的支付成功时间格式: RFC3339
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 25, message = "paymentSucceededAt长度不能超过25")
    private String paymentSucceededAt;

    /**
     * 备注
     * 备注信息
     *
     * (选填)
     */
    @Length(max = 255, message = "remark长度不能超过255")
    private String remark;

    /**
     * 扩展字段
     * 预留扩展字段交易涉及的商品信息，根据必传要求上 送，参考示例，则必 传，参考示例
     * {@link ShandeProductInfoItemRequest}
     * extra[notifyUrl] 交易结果通知地址,用于接收异步通知地址的 URL
     * (特殊必填)
     */
    private Map<String,Object> extra;

    /**
     * 自定义参数
     * {"purpose":"123456"}
     *
     * (选填)
     */
    private Map<String,Object> metadata;

}