/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.common;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 中台监管账户交易密码入参
 *
 * @author
 * @version ShandeAcctPasswordsRequest.java, v 0.1 2022-12-06 11:52:07
 */
@Data
public class ShandeAcctPasswordsRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555923449289L;


    /**
     * 电子账簿ID
     * 
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 类型
     * 1：重置密码2:  修改密码
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "type长度不能超过1")
    private String type;

    /**
     * 鉴权验证是否通过短信发送
     * 默认不发送0：不发送1：发送
     *
     * (选填)
     */
    @Length(max = 1, message = "isSendMsg长度不能超过1")
    private String isSendMsg;

}