/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.remit.agent.response;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * 衫德请求
 *
 * @author liluqing
 * @version ShandeBaseRequest.java, v 0.1 2023-09-20 13:42 liluqing
 */
@Data
public class ShandeBaseResponse<T extends ShandeBizResponse> implements Serializable {

    private static final long serialVersionUID = 4675589039204163814L;

    /**
     * 交易码
     */
    private String transCode;

    /**
     * 平台标识
     */
    private String accessPlatform;

    /**
     * 合作商户ID	杉德系统分配，唯一标识
     */
    private String merId;

    /**
     * 接入类型
     */
    private String accessType;

    /**
     * 平台商户ID	平台接入必填，商户接入为空
     */
    private String plId;

    /**
     * 加密后的AES秘钥
     */
    @JSONField(serialize = false)
    private String encryptKey;

    /**
     * 加密后的请求/应答报文
     */
    @JSONField(serialize = false)
    private String encryptData;

    /**
     * 返回业务结果
     */
    private T data;

    /**
     * 签名
     */
    private String sign;
}