/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.remit.agent.request.remit;

import com.fshows.remit.agent.request.ShandeBizRequest;
import com.fshows.remit.agent.response.remit.ShandeAgentPayResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * 代付接口请求参数
 *
 * @author liluqing
 * @version ShandeAgentPayRequest.java, v 0.1 2023-09-20 14:24
 */
@Data
public class ShandeAgentPayRequest extends ShandeBizRequest<ShandeAgentPayResponse> implements Serializable {

    private static final long serialVersionUID = 2781695855884327450L;

    /**
     * 版本号
     */
    private String version = "01";

    /**
     * 产品ID
     * 付款对私：00000004
     * 付款对公：00000003
     */
    private String productId;

    /**
     * 交易时间,格式：yyyyMMddHHmmss
     */
    private String tranTime;

    /**
     * 订单号,合作商户唯一，建议订单号中包含日期
     */
    private String orderCode;

    /**
     * 订单超时时间,不填默认24小时
     */
    private String timeOut;

    /**
     * 金额,精确到分，不足12位前面补0
     */
    private String tranAmt;

    /**
     * 币种,固定156
     */
    private String currencyCode;

    /**
     * 账户属性
     * 0-对私
     * 1-对公
     * 注：accAttr选择对私时，accType选银行卡
     */
    private String accAttr;

    /**
     * 账号类型
     * 3-公司账户
     * 4-银行卡
     *
     * 注：accAttr选择对公时，accType选公司账户
     */
    private String accType;

    /**
     * 收款人账户号
     */
    private String accNo;

    /**
     * 收款人账户名
     */
    private String accName;

    /**
     * 收款人开户省份编码
     */
    private String provNo;

    /**
     * 收款人开户城市编码
     */
    private String cityNo;

    /**
     * 收款账户开户行名称
     */
    private String bankName;

    /**
     * 对公付款必填（产品ID为0000003时）
     */
    private String bankType;

    /**
     * 摘要
     */
    private String remark;

    /**
     * 付款模式
     */
    private String payMode;

    /**
     * 渠道类型
     */
    private String channelType;

    /**
     * 业务扩展参数
     */
    private String extendParams;

    /**
     * 请求方保留域
     * 如需发送交易结果至收款方，则必填，值为收款方的短信通知内容
     */
    private String reqReserved;

    /**
     * 扩展域
     */
    private String extend;

    /**
     * 手机号
     */
    private String phone;

    @Override
    public Class<ShandeAgentPayResponse> getResponseClass() {
        return ShandeAgentPayResponse.class;
    }
}
