package com.fshows.com.shande.openapi.sdk.util;

import com.fshows.com.shande.openapi.sdk.crypto.AESWithCBCStrategy;
import com.fshows.com.shande.openapi.sdk.crypto.AESWithECBStrategy;
import com.fshows.com.shande.openapi.sdk.crypto.CryptoEncryptionService;
import com.fshows.com.shande.openapi.sdk.crypto.CryptoSignatureService;
import com.fshows.com.shande.openapi.sdk.crypto.RSACryptoWithHardwareStrategy;
import com.fshows.com.shande.openapi.sdk.crypto.RSACryptoWithSoftwareStrategy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

/**
 * 验签解密获取加解密服务等
 *
 * @author yuancheng@belink.com
 * @date 2018/12/4
 */
public class CryptoServiceUtils {

    /**
     * AES加密服务MAP
     */
    private static volatile Map<String, CryptoEncryptionService> cryptoAESEncryptionServiceMap = new HashMap<>();

    /**
     * RSA加密服务
     */
    private static volatile Map<String, CryptoEncryptionService> cryptoRSAEncryptionServiceMap = new HashMap<>();

    /**
     * 签名服务MAP
     */
    private static volatile Map<String, CryptoSignatureService> cryptoSignatureServiceMap = new HashMap<>();

    static {
        try {
            initialCryptoService();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private static void initialCryptoService() throws Exception {
        final HashSet<CryptoEncryptionService> cryptoAESEncryptionServiceSet = new HashSet<>();
        cryptoAESEncryptionServiceSet.add(new AESWithCBCStrategy());
        cryptoAESEncryptionServiceSet.add(new AESWithECBStrategy());
        initialCryptoAESEncryptionService(cryptoAESEncryptionServiceSet);

        final HashSet<CryptoEncryptionService> cryptoRSAEncryptionServiceSet = new HashSet<>();
        cryptoRSAEncryptionServiceSet.add(new RSACryptoWithHardwareStrategy());
        cryptoRSAEncryptionServiceSet.add(new RSACryptoWithSoftwareStrategy());
        initialCryptoRSAEncryptionService(cryptoRSAEncryptionServiceSet);

        final HashSet<CryptoSignatureService> CryptoSignatureServiceSet = new HashSet<>();
        CryptoSignatureServiceSet.add(new RSACryptoWithHardwareStrategy());
        CryptoSignatureServiceSet.add(new RSACryptoWithSoftwareStrategy());
        initialCryptoSignatureService(CryptoSignatureServiceSet);
    }

    private static void initialCryptoAESEncryptionService(
            HashSet<CryptoEncryptionService> cryptoEncryptionServiceClassSet) throws Exception {
        for (CryptoEncryptionService cryptoEncryptionService : cryptoEncryptionServiceClassSet) {
            cryptoAESEncryptionServiceMap.put(cryptoEncryptionService.getAlgorithmType(), cryptoEncryptionService);
        }
    }

    private static void initialCryptoRSAEncryptionService(
            HashSet<CryptoEncryptionService> cryptoEncryptionServiceClassSet) throws Exception {
        for (CryptoEncryptionService cryptoEncryptionService : cryptoEncryptionServiceClassSet) {
            cryptoRSAEncryptionServiceMap.put(cryptoEncryptionService.getAlgorithmType(), cryptoEncryptionService);
        }
    }

    private static void initialCryptoSignatureService(
            HashSet<CryptoSignatureService> cryptoSignatureServiceSet) throws Exception {
        for (CryptoSignatureService cryptoSignatureService : cryptoSignatureServiceSet) {
            cryptoSignatureServiceMap.put(cryptoSignatureService.getAlgorithmType(), cryptoSignatureService);
        }
    }

    /**
     * 根据加密类型获取加解密服务
     *
     * @param encryptType 加解密类型
     */
    public static CryptoEncryptionService getCryptoAESEncryptionService(String encryptType) throws Exception {
        String typeUpperCase = encryptType.toUpperCase(Locale.getDefault());
        return cryptoAESEncryptionServiceMap.get(typeUpperCase);
    }

    /**
     * 增加AES加解密服务
     *
     * @param cryptoEncryptionService 加解密服务
     */
    public static void putCryptoAESEncryptionService(CryptoEncryptionService cryptoEncryptionService) {
        if (cryptoEncryptionService != null) {
            cryptoAESEncryptionServiceMap.put(cryptoEncryptionService.getAlgorithmType(), cryptoEncryptionService);
        }
    }

    /**
     * 根据加密类型获取加解密服务
     *
     * @param encryptType 加解密类型
     */
    public static CryptoEncryptionService getCryptoRSAEncryptionService(String encryptType) throws Exception {
        String typeUpperCase = encryptType.toUpperCase(Locale.getDefault());
        return cryptoRSAEncryptionServiceMap.get(typeUpperCase);
    }

    /**
     * 增加RSA加解密服务
     *
     * @param cryptoEncryptionService 加解密服务
     */
    public static void putCryptoRSAEncryptionService(CryptoEncryptionService cryptoEncryptionService) {
        if (cryptoEncryptionService != null) {
            cryptoRSAEncryptionServiceMap.put(cryptoEncryptionService.getAlgorithmType(), cryptoEncryptionService);
        }
    }

    /**
     * 根据签名类型获取签名服务
     *
     * @param signType 签名类型
     */
    public static CryptoSignatureService getCryptoSignatureService(String signType) throws Exception {
        String typeUpperCase = signType.toUpperCase(Locale.getDefault());
        return cryptoSignatureServiceMap.get(typeUpperCase);
    }

    /**
     * 增加签名验签服务
     *
     * @param cryptoSignatureService 签名验签服务
     */
    public static void putCryptoSignatureService(CryptoSignatureService cryptoSignatureService) {
        if (cryptoSignatureService != null) {
            cryptoSignatureServiceMap.put(cryptoSignatureService.getAlgorithmType(), cryptoSignatureService);
        }
    }

}
