package com.fshows.com.shande.openapi.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 加签类型
 *
 * @author liluqing
 * @version SignTypeEnum.java, v 0.1 2022-03-02 15:33 liluqing
 */
public enum SignTypeEnum {

    MD5WithRSA("RSA", "MD5WithRSA", "MD5WithRSA"),
    SHA1WithRSA("SHA1WithRSA", "SHA1WithRSA", "SHA1WithRSA")
    ;

    private String name;
    private String value;
    private String algorithm;

    SignTypeEnum(String name, String value, String algorithm) {
        this.name = name;
        this.value = value;
        this.algorithm = algorithm;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    /**
     * Getter method for property <tt>algorithm</tt>.
     *
     * @return property value of algorithm
     */
    public String getAlgorithm() {
        return algorithm;
    }

    public static SignTypeEnum getByValue(String value) {
        SignTypeEnum[] valueList = SignTypeEnum.values();
        for (SignTypeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}