/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.merchant;

import com.fshows.shande.sdk.response.books.item.ShandeAcctValidationResponse;
import com.fshows.shande.sdk.response.merchant.item.ShandeEntryFailureMsgsResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 二级商户进件状态查询响应结果
 *
 * @author
 * @version ShandeApplicationsSubmchQueryResponse.java, v 0.1 2022-12-06 14:56:10
 */
@Data
public class ShandeApplicationsSubmchQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555596339022L;


    /**
     * 进件状态
     * 枚举值：checking：资料校验中account_need_veri fy：待账户验证auditing：审核中
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "applicationStatus长度不能超过20")
    private String applicationStatus;

    /**
     * 二级商户 ID
     * 系统生成的唯一商户号当进件状态为 succeeded 时返回的用户 ID
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "mchId长度不能超过19")
    private String mchId;

    /**
     * 账户验证通过时间
     * 当进件需要账户验证且验证通过后返回。格式: RFC3339
     *
     * (特殊必填)
     */
    private String acctVerifiedAt;

    /**
     * 审核通过时间
     * 当进件需要人工审核且审核通过后返回。格式: RFC3339
     *
     * (特殊必填)
     */
    private String auditedAt;

    /**
     * 进件申请通过时间
     * 当进件状态为succeeded 时返回。格式: RFC3339
     *
     * (特殊必填)
     */
    private String succeededAt;

    /**
     * 进件申请失败时间
     * 当进件状态为 failed 时返回。格式: RFC3339
     *
     * (特殊必填)
     */
    private String failedAt;

    /**
     * 账户验证信
     * 当进件状态为：
     *
     * (特殊必填)
     */
    private ShandeAcctValidationResponse acctValidation;

    /**
     * 审核失败原因
     * 进件状态为 failed 或frozen 时，且字段有值时返回
     *
     * (特殊必填)
     */
    private List<ShandeEntryFailureMsgsResponse> failureMsgs;

    /**
     * 平台订单号
     * 1、平台自定义的唯一编号2、每个平台订单号对应一个系统订单号，每个系统订单号创建成功后会生成一个二级商户 ID3、若申请单审核“失败”，可使用相同的“平台订单号”再次请求，覆盖原申请单信息4、要求 64 个字符内，只能是数字、大小写
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

    /**
     * 系统订单号
     * 系统申请单的主键，唯一定义此资源的标识
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "mchApplicationId长度不能超过19")
    private String mchApplicationId;

    /**
     * 电子账簿账簿号
     * 1、当进件状态为succeeded 时返回2、由系统生成的电子账簿账簿号，可作为收款信息，用于接收外部转账充值等3、可能存在与用户 ID、电子账簿 ID、绑定账户 ID 无法同时生成的情况，需要再次通过查询接口获取4、仅首次进件返回
     *
     * (特殊必填)
     */
    @Length(max = 24, message = "relAcctNo长度不能超过24")
    private String relAcctNo;

    /**
     * 银行生成的户名
     * 当通过 rel_acct_no进行虚户绑定时银行返回的虚户名称
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "bindAcctName长度不能超过64")
    private String bindAcctName;

    /**
     * 电子账簿 ID
     * 1、当进件状态为succeeded 时返回 2、仅首次进件返回
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 绑定账户 ID
     * 当进件状态为
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "settleAcctId长度不能超过19")
    private String settleAcctId;

    /**
     * 自定义参数
     * {"description":"123456"}
     *
     * (选填)
     */
    private Map<String, String> metadata;

    /**
     * 额外信息
     * 按管理后台配置情况填写
     *
     * 可能的值：
     * contractNo - 合同编号,平台的签约合同编号，按管理后台配置情况填写（暂不支持）
     * (特殊必填)
     */
    private Map<String, Object> extra;
}