package com.fshows.shande.sdk.response.fund.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author liangyuanping
 * @version ShandeProductInfoItemResponse.java, v 0.1 2022-12-06 11:14 AM
 */
@Data
public class ShandeProductInfoItemResponse implements Serializable {
    /**
     * 订单编号
     * 要求 64 个字符内，只能是数字、大小写字母和_-
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "extra[productInfos][*][orderNo]长度不能超过64")
    private String orderNo;

    /**
     * 订单金额
     * 单位为分，要求不能带小数点
     * <p>
     * (特殊必填)
     */
    private Integer orderAmount;

    /**
     * 商品名称
     * 商品名称
     * <p>
     * (特殊必填)
     */
    @Length(max = 255, message = "extra[productInfos][*长度不能超过255")
    private String productName;


    /**
     * 商品数量
     * 最大 9999
     * <p>
     * (特殊必填)
     */
    private Integer productCount;
}