/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.fund;

import com.fshows.shande.sdk.response.fund.item.ShandeProductInfoItemResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * 充值订单查询响应结果
 *
 * @author
 * @version ShandeDepositsQueryInResponse.java, v 0.1 2022-12-06 14:58:39
 */
@Data
public class ShandeDepositsQueryInResponse implements Serializable {

    private static final long serialVersionUID = -2213838555393693800L;


    /**
     * 系统订单号
     * 由系统生成的唯一单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "depositId长度不能超过19")
    private String depositId;

    /**
     * 交易状态
     * succeeded: 成功processing: 处理中failed: 失败
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "status长度不能超过10")
    private String status;

    /**
     * 入账状态
     * wait_credit: 等待入账credited: 已入账 none_credited: 无需入账
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 25, message = "creditStatus长度不能超过25")
    private String creditStatus;

    /**
     * 失败原因
     * 失败时的具体错误原因描述
     *
     * (特殊必填)
     */
    @Length(max = 200, message = "reason长度不能超过200")
    private String reason;

    /**
     * 创建时间
     * 格式: RFC3339
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 25, message = "createdAt长度不能超过25")
    private String createdAt;

    /**
     * 处理完成时间
     * 格式: RFC3339
     *
     * (特殊必填)
     */
    @Length(max = 25, message = "finishedAt长度不能超过25")
    private String finishedAt;

    /**
     * 平台订单号
     * 平台的唯一请求单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

    /**
     * 总金额
     * 充值订单总金额，单位为分
     *
     * (必填)
     */
    @NotNull
    private Integer totalAmount;

    /**
     * 支付金额
     * 单位为分，充值订单用
     *
     * (必填)
     */
    @NotNull
    private Integer amount;

    /**
     * 平台优惠金额
     * 单位为分，平台用于营销补贴的金额
     *
     * (必填)
     */
    @NotNull
    private Integer discountAmount;

    /**
     * 优惠订单系统订单号
     * 优惠金额关联的系统订单号，使用平台平台优惠金额时返回
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "discountId长度不能超过19")
    private String discountId;

    /**
     * 电子账簿 ID
     * 记账用户的电子账簿编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 支付类型
     * 支付通道类型参照：支付类型编码
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "paymentType长度不能超过20")
    private String paymentType;

    /**
     * 支付通道订单号
     * 支付通道订单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "paymentTradeNo长度不能超过64")
    private String paymentTradeNo;

    /**
     * 支付成功时间
     * 支付通道返回的支付成功时间，格式:RFC3339
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 25, message = "paymentSucceededAt长度不能超过25")
    private String paymentSucceededAt;

    /**
     * 已退款金额
     * 充值退款金额，单位为分，未退款时该金额为 0
     *
     * (必填)
     */
    @NotNull
    private Integer refundedAmount;

    /**
     * 备注
     * 备注信息
     *
     * (选填)
     */
    @Length(max = 255, message = "remark长度不能超过255")
    private String remark;

    /**
     * 扩展字段
     * 预留扩展字段
     *
     * {@link ShandeProductInfoItemResponse}
     *
     * (特殊必填)
     */
    private Map<String,Object> extra;

    /**
     * 自定义参数
     * {"purpose":"123456"}
     *
     * (选填)
     */
    private Map<String,Object> metadata;

}