/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.common;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 上传图片响应结果
 *
 * @author
 * @version ShandeUploadImageResponse.java, v 0.1 2022-12-06 10:46:51
 */
@Data
public class ShandeUploadImageResponse implements Serializable {

    private static final long serialVersionUID = -2213838555152897130L;


    /**
     * 媒体文件 ID
     * 系统返回的媒体文件标识 ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "mediaId长度不能超过255")
    private String mediaId;

}