/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.response.books.item;

import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 账户验证信息
 *      当账户验证状态为processing 时返回，可根据指引完成账户验证
 *
 * @author liluqing
 * @version ShandeAcctValidationResponse.java, v 0.1 2022-12-06 10:54
 */
public class ShandeAcctValidationResponse {

    /**
     * 验证类型
     * 枚举值：1: 平台用户向银行
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "type长度不能超过1")
    private String type;

    /**
     * 付款户名
     * 验证类型为表示平台账户名表示银行账户名
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "acctName长度不能超过64")
    private String acctName;

    /**
     * 付款账户号
     * 验证类型为表示平台账户号表示银行账户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "acctNo长度不能超过64")
    private String acctNo;

    /**
     * 汇款金额
     * 验证类型为1 时返回需要汇款的金额，单位为分
     *
     * (特殊必填)
     */
    private Integer payAmount;

    /**
     * 收款账户户名
     * 验证类型为表示银行账户名表示平台账户名
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "destAcctName长度不能超过64")
    private String destAcctName;

    /**
     * 收款账户账号
     * 验证类型为表示银行账户号表示平台账户号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "destAcctNo长度不能超过64")
    private String destAcctNo;

    /**
     * 收款账户开户银行联行号
     * 验证类型为表示银行账户开户银行联行号表示平台账户开户银行联行号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "destAcctBankB ranchCode长度不能超过12")
    private String destAcctBankBranchCode;

    /**
     * 收款账户省市信息
     * 验证类型为表示银行账户省市信息表示平台账户省市信息
     *
     * (选填)
     */
    @Length(max = 6, message = "destAcctBankA ddressCode长度不能超过6")
    private String destAcctBankAddressCode;

    /**
     * 收款账户备注信息
     * 用于二级商户账户验证时，填写备注信息
     *
     * (选填)
     */
    @Length(max = 255, message = "memo长度不能超过255")
    private String memo;

    /**
     * 账户验证截止时间
     * 账户验证截止时间格式:RFC3339
     *
     * (必填)
     */
    @NotNull
    private String deadline;
}