/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.books;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 电子回单生成（查询）响应结果
 *
 * @author
 * @version ShandeElectronicReceiptsQueryResponse.java, v 0.1 2022-12-06 11:31:19
 */
@Data
public class ShandeElectronicReceiptsQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555937973064L;


    /**
     * 系统订单号
     * 由系统生成的唯一单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "electronicReceiptId长度不能超过19")
    private String electronicReceiptId;

    /**
     * 交易的系统订单号
     * 
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "tradeId长度不能超过64")
    private String tradeId;

    /**
     * 交易的平台订单号
     * 
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

    /**
     * 交易类型
     * 枚举值：payment - 消费（转账） rel_acct_deposit - 转账入金 allocation - 分账子订单 guarantee_confirm - 担保确认 withdrawal_succeeded-提现 large_payment- 大额订单
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "tradeType长度不能超过64")
    private String tradeType;

    /**
     * 回单状态
     * succeeded: 成功processing: 处理中 failed: 失败
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "receiptStatus长度不能超过10")
    private String receiptStatus;

    /**
     * 回单文件
     * 回单状态为 succeeded 时返回链接有效期为 15 分钟
     *
     * (特殊必填)
     */
    @Length(max = 255, message = "fileUrl长度不能超过255")
    private String fileUrl;

}