/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.books;

import com.fshows.shande.sdk.response.books.item.ShandeBalanceTransactionsDataResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.List;

/**
 * 电子账簿流水查询响应结果
 *
 * @author
 * @version ShandeBalanceTransactionsResponse.java, v 0.1 2022-12-06 11:54:32
 */
@Data
public class ShandeBalanceTransactionsResponse implements Serializable {

    private static final long serialVersionUID = -2213838555202559191L;


    /**
     * 总条数
     * 
     *
     * (必填)
     */
    @NotNull
    private Integer total;

    /**
     * 下一页游标
     * 需要获取下一页数据时，将该字段的值作为请求时 cursor 参数进行请求
     *
     * (选填)
     */
    @Length(max = 200, message = "nextCursor长度不能超过200")
    private String nextCursor;

    /**
     * 页面条数
     * 
     *
     * (选填)
     */
    private Integer size;

    /**
     * 数据列表
     * 
     *
     * (必填)
     */
    @NotNull
    private List<ShandeBalanceTransactionsDataResponse> data;

}