/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.account;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 删除绑定账户响应结果
 *
 * @author
 * @version ShandeAccountDeleteBindingResponse.java, v 0.1 2022-12-06 13:42:24
 */
@Data
public class ShandeAccountDeleteBindingResponse implements Serializable {

    private static final long serialVersionUID = -2213838555313764629L;


    /**
     * 绑定账户编号
     * 系统生成的唯一编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "settleAcctId长度不能超过19")
    private String settleAcctId;

    /**
     * 平台订单号
     * 1、平台自定义的唯一编号2、每个平台订单号对应一个系统订单号，每个系统订单号进件通过后会生成一个个人用户或二级商户 ID3、若申请单审核失败，可填写 相同的“平台订单号”，即可覆 盖修改原申请单信息4、要求 64 个字符内，只能是数字、大小写字母和_-
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

    /**
     * 是否删除成功
     * true 删除成功false 删除失败
     *
     * (必填)
     */
    @NotNull
    private Boolean isDeleted;

}