/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.account;

import com.fshows.shande.sdk.response.books.item.ShandeAcctValidationResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;
import org.omg.CORBA.OBJ_ADAPTER;

import java.io.Serializable;
import java.util.Map;

/**
 * 新增绑定账户响应结果
 *
 * @author
 * @version ShandeAccountAddBindingResponse.java, v 0.1 2022-12-06 13:59:03
 */
@Data
public class ShandeAccountAddBindingResponse implements Serializable {

    private static final long serialVersionUID = -2213838555730708100L;


    /**
     * 账户验证状态
     * 枚举值：
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "verifyStatus长度不能超过10")
    private String verifyStatus;

    /**
     * 银行账户类型
     * 枚举值：- 对私银行卡- 对公银行账户
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "bankAcctType长度不能超过1")
    private String bankAcctType;

    /**
     * 开户名称
     * 开户名称
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "name长度不能超过64")
    private String name;

    /**
     * 开户银行编码
     * 开户银行编码
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "bankCode长度不能超过12")
    private String bankCode;

    /**
     * 银行省市编码
     * 开户银行省市编码
     *
     * (选填)
     */
    @Length(max = 6, message = "bankAddressCode长度不能超过6")
    private String bankAddressCode;

    /**
     * 开户银行联行号
     * 开户银行联行号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "bankBranchCode长度不能超过12")
    private String bankBranchCode;

    /**
     * 银行账号
     * 银行账号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 34, message = "bankAcctNo长度不能超过34")
    private String bankAcctNo;

    /**
     * 绑定的手机号
     * 银行卡预留的手机号，对私账户类型时存在
     *
     * (特殊必填)
     */
    @Length(max = 20, message = "mobileNumber长度不能超过20")
    private String mobileNumber;

    /**
     * 账户验证信息
     * 当账户验证状态为processing 时返回，可根据指引完成账户验证
     *
     * (特殊必填)
     */
    private ShandeAcctValidationResponse acctValidation;

    /**
     * 绑定账户编号
     * 系统生成的唯一编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "settleAcctId长度不能超过19")
    private String settleAcctId;

    /**
     * 平台订单号
     * Path1、平台自定义的唯
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

    /**
     * 账户验证完成时间
     * 账户验证的成功或失败时间
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "acctValidationFinishedAt长度不能超过255")
    private String acctValidationFinishedAt;

    /**
     * 账户验证失败原因
     * 当账户验证状态为failed 时返回
     *
     * (特殊必填)
     */
    @Length(max = 255, message = "acctValidationFailureMsg长度不能超过255")
    private String acctValidationFailureMsg;

    /**
     * 自定义参数
     * {"description":"123456"}
     *
     * (选填)
     */
    private Map<String, String> metadata;

    /**
     * 额外信息
     * 按管理后台配置情况填写
     *
     * 可设置参数：
     * authType - 按管理后台配置情况填写二级商户可选 1: 小额打款个人用户可选2: 二要素鉴权;3: 三要素鉴权;4: 四要素鉴权
     *
     * (特殊必填)
     */
    private Map<String, Object> extra;
}