/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.shande.sdk.response;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 衫德响应对象
 *
 * @author linzy
 * @version ShandeResponse.java, v 0.1 2022-12-02 13:42 linzy
 * @date 2022/12/-2
 */
@Data
public class ShandeResponseBody<R> implements Serializable {

    private static final long serialVersionUID = 4765955044550193521L;

    /**
     * 接口请求成功响应码 0000 成功
     */
    private String responseCode;
    private String responseDesc;
    private String responseTime;
    private String customerOrderNo;

    private R data;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}