package com.fshows.shande.sdk.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author liangyuanping
 * @version ShandeIdCardItemRequest.java, v 0.1 2022-12-06 2:04 PM
 */
@Data
public class ShandeIdCardItemRequest implements Serializable {

    /**
     * 证件人像面照片
     * 1、请上传身份证人像面照片2、可上传 1 张图片，请填写通过[图片上传]接口预先上传图片生成好的 media_id
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "idCard[copy]长度不能超过255")
    private String copy;

    /**
     * 证件国徽面照片
     * 1、请上传身份件国徽面照片2、可上传 1 张图片，请填写通过[图片上传]接口预先上传图片生成好的 media_id
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "idCard[national]长度不能超过255")
    private String national;

    /**
     * 证件号码
     * 1、请填写证件类型对应的号码，为 15 位数字或17 位数字+1 位数字|X
     *
     * (必填)
     */
    @Length(max = 64, message = "idCard[number]长度不能超过64")
    private String number;

    /**
     * 证件名称
     * 1、请填写证件上的姓名
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "idCard[name]长度不能超过64")
    private String name;

    /**
     * 证件有效期
     * 1、若证件有效期为长期，到期时间请填写：长期 2、填写起止日期并用逗号隔开，格式：1990-01-01，长期3、证件有效期到期时间必须大于 60 天，即到期时间距当前时间需超过 60天
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "idCard[validTime]长度不能超过32")
    private String validTime;

    /**
     * 发证机关
     * 发证机关
     *
     * (特殊必填)
     */
    @Length(max = 128, message = "idCard[idCardIssuingAuthority]长度不能超过128")
    private String idCardIssuingAuthority;

}