/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 实际控制企业信息
 *
 * @author liluqing
 * @version ShandeHoldingCompanyRequest.java, v 0.1 2022-12-06 14:39
 */
@Data
public class ShandeHoldingCompanyRequest implements Serializable {
    private static final long serialVersionUID = -2213838555911708488L;

    /**
     * 股东类型
     * 枚举值：- 企业- 个人
     *
     * (选填)
     */
    @Length(max = 1, message = "type长度不能超过1")
    private String type;

    /**
     * 实际控制企业名称
     * 实际控制企业名称支持中文、字母、数字、括号、& 符号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "name长度不能超过64")
    private String name;

    /**
     * 实际控制企业营业执照号
     * 实际控制企业营业执照号，须为 15 位/18 位数字或字母
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 18, message = "licenseNum ber长度不能超过18")
    private String licenseNumber;

    /**
     * 实际控制企业营业期限
     * 1、若证件有效期为长期，到期时间请填写：长期 2、到期时间需晚于成立时间3、有效期必须大于60 天，即结束时间距当前时间需超过 60 天4、格式：1990-01-01，长期
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "licenseValidTime长度不能超过32")
    private String licenseValidTime;

    /**
     * 实际控股人/企业证件类型
     * 实际控股人/企业证件类型,枚举值：1-营业执照 2-其它
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "licenseType长度不能超过1")
    private String licenseType;
}