package com.fshows.shande.sdk.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author liangyuanping
 * @version ShandeFailureMsgItemRequest.java, v 0.1 2022-12-06 2:21 PM
 */
@Data
public class ShandeFailureMsgItemRequest implements Serializable {

    /**
     * 审核失败参数
     * 提交申请单的资料项名称
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "failureMsgs[*][param]长度不能超过32")
    private String param;

    /**
     * 审核失败驳回原因
     * 提交申请单的资料项被驳回原因
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "failureMsgs[*][reason]长度不能超过64")
    private String reason;
}