/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.merchant;

import com.fshows.shande.sdk.request.merchant.item.ShandeApplicationsSettleAcctRequest;
import com.fshows.shande.sdk.request.merchant.item.ShandeBeneficiaryIdCardRequest;
import com.fshows.shande.sdk.request.merchant.item.ShandeBusinessInfoRequest;
import com.fshows.shande.sdk.request.merchant.item.ShandeBusinessLicenseRequest;
import com.fshows.shande.sdk.request.merchant.item.ShandeContactIdCardRequest;
import com.fshows.shande.sdk.request.merchant.item.ShandeHoldingCompanyRequest;
import com.fshows.shande.sdk.request.merchant.item.ShandeLegalPersonIdCardRequest;
import com.fshows.shande.sdk.request.merchant.item.ShandeOrganizationCertRequest;
import com.fshows.shande.sdk.request.merchant.item.ShandeTaxRegistrationCertRequest;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

import java.util.List;
import java.util.Map;

/**
 * 二级商户信息修改入参
 *
 * @author
 * @version ShandeApplicationsSubmchUpdateRequest.java, v 0.1 2022-12-06 14:07:04
 */
@Data
public class ShandeApplicationsSubmchUpdateRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555335166394L;


    /**
     * 二级商户 ID
     * 进件成功返回的二级商户 ID示例值： 1002382477306497081
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "mchId长度不能超过19")
    private String mchId;

    /**
     * 平台订单号
     * 1、平台自定义的唯一编号2、每个平台订单号对应一个系统订单号，每个系统订单号创建成功后会生成一个二级商户 ID3、若申请单审核“失败”，可使用相同的“平台订单号”再次请求，覆盖原申请单信息4、要求 64 个字符内，只能是数字、大小写字母和_-5、不要使用申请时填写的平台订单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

    /**
     * 商户简称
     * 商户简称，支持中文、字母、数字、括号、& 符号最长 16 个汉字
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 16, message = "shortName长度不能超过16")
    private String shortName;

    /**
     * 企业英文名称
     * 企业英文名称,是否必传取决于平台业务参数配置
     *
     * (特殊必填)
     */
    @Length(max = 128, message = "englishName长度不能超过128")
    private String englishName;

    /**
     * 营业执照信息
     * 营业执照信息
     *
     * (必填)
     */
    @NotNull
    private ShandeBusinessLicenseRequest businessLicense;

    /**
     * 组织机构代码证
     * 营业执照证件号码不是 18位时必填
     *
     * (特殊必填)
     */
    private ShandeOrganizationCertRequest organizationCert;

    /**
     * 税务登记证
     * 营业执照证件号码不是 18位时必填
     *
     * (特殊必填)
     */
    private ShandeTaxRegistrationCertRequest taxRegistrationCert;

    /**
     * 绑定账户信息
     * 绑定账户信息。
     *
     * (必填)
     */
    @NotNull
    private ShandeApplicationsSettleAcctRequest settleAcct;

    /**
     * 法人证件信息
     * 请填写法定代表人的证件信息
     *
     * (必填)
     */
    @NotNull
    private ShandeLegalPersonIdCardRequest legalPersonIdCard;

    /**
     * 联系人证件信息
     * 联系人将接收日常重要管理信息，若不填写，则自动使用法人证件信息作为联系人证件信息
     *
     * (选填)
     */
    private ShandeContactIdCardRequest contactIdCard;

    /**
     * 法人手机号
     * 1、请填写法人的手机号2、仅主体类型为 2 -个体工商户时必填3、11位数字
     *
     * (特殊必填)
     */
    @Length(max = 11, message = "legalPersonMobileNumber长度不能超过11")
    private String legalPersonMobileNumber;

    /**
     * 短信验证码
     * 1、通过[个人手机号验证码]接口获取的短信验证码，用于验证法人手机号 2、二级商户主体类型为个体工商户时，如绑定账户为法人个人账户，需要对手机号进行 验证码校验3、在第 2 点的情况 下，短信验证码必传4、非第 2 点的场景下，不需送值
     *
     * (特殊必填)
     */
    @Length(max = 6, message = "smsCode长度不能超过6")
    private String smsCode;

    /**
     * 联系人手机号
     * 1、请填写联系人的手机号，11 位数字，用于接收的重要信息及日常操作验证码
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 11, message = "contactMobileNumber长度不能超过11")
    private String contactMobileNumber;

    /**
     * 联系人邮箱
     * 1、需要带@，遵循邮箱格式校验
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "contactEmail长度不能超过128")
    private String contactEmail;

    /**
     * 企业信息
     * 企业信息
     *
     * (选填)
     */
    private ShandeBusinessInfoRequest businessInfo;

    /**
     * 实际控制企业信息
     * 实际控制企业信息
     *
     * (特殊必填)
     */
    private ShandeHoldingCompanyRequest holdingCompany;

    /**
     * 补充说明图片
     * 1、最多可上传 5 张照片：请填写通过[图片上传接口]预先上传图片生成好的 media_id2、格式： ["jTpGmg05InE4d2I6_H7 I4"]
     *
     * (选填)
     */
    private List<String> additionImgs;

    /**
     * 补充说明文字
     * 特殊情况，说明原因
     *
     * (选填)
     */
    @Length(max = 255, message = "additionDesc长度不能超过255")
    private String additionDesc;

    /**
     * 受益所有人信息
     * 受益所有人信息,
     *
     * (选填)
     */
    private ShandeBeneficiaryIdCardRequest beneficiaryIdCard;



    /**
     * 受益所有人地址
     * 受益所有人地址
     *
     * (选填)
     */
    @Length(max = 64, message = "beneficiaryAddress长度不能超过64")
    private String beneficiaryAddress;

    /**
     * 自定义参数
     * {"description":"123456"}
     *
     * (选填)
     */
    private Map<String, String> metadata;

    /**
     * 额外信息
     * 按管理后台配置情况填写
     *
     * 可设置的值
     * contractNo - 合同编号,平台的签约合同编号，按管理后台配置情况填写
     * (选填)
     */
    private Map<String, Object> extra;
}