/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.merchant;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 二级商户进件状态查询入参
 *
 * @author
 * @version ShandeApplicationsSubmchQueryRequest.java, v 0.1 2022-12-06 14:56:09
 */
@Data
public class ShandeApplicationsSubmchQueryRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555340872621L;


    /**
     * 系统订单号-二级商户进件
     * 系统申请单的主键，唯一定义此资源的标识系统订单号和平台订单号二选一
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "mchApplicationId长度不能超过19")
    private String mchApplicationId;

    /**
     * 平台订单号
     * 1、平台自定义的唯一编号2、要求 64 个字符内，只能是数字、大小写字母和_-系统订单号和平台订单号二选一
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

}