/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.fund;

import com.fshows.shande.sdk.request.ShandeRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 提现订单查询入参
 *
 * @author
 * @version ShandeFundWithdrawalsQueryRequest.java, v 0.1 2022-12-06 09:15:14
 */
@Data
public class ShandeFundWithdrawalsQueryRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555460661432L;


    /**
     * 系统订单号
     * 系统订单号和平台订单号二选一
     * <p>
     * (特殊必填)
     */
    @Length(max = 19, message = "withdrawalId长度不能超过19")
    private String withdrawalId;

    /**
     * 平台订单号
     * 系统订单号和平台订单号二选一
     * <p>
     * (特殊必填)
     */
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

}