/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.fund;

import com.fshows.shande.sdk.request.ShandeRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 消费（转账）订单查询入参
 *
 * @author
 * @version ShandeFundPaymentsOutQueryRequest.java, v 0.1 2022-12-06 09:21:23
 */
@Data
public class ShandeFundPaymentsOutQueryRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555617581586L;


    /**
     * 系统订单号
     * 系统订单号和平台订单号二选一
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "paymentId长度不能超过19")
    private String paymentId;

    /**
     * 平台订单号
     * 系统订单号和平台订单号二选一
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

}