/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.fund;

import com.fshows.shande.sdk.request.ShandeRequest;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 配置电子账簿关联关系入参
 *
 * @author
 * @version ShandeFundBalancePaymentsAddOutRequest.java, v 0.1 2022-12-06 09:28:05
 */
@Data
public class ShandeFundBalancePaymentsAddOutRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555921374860L;

    /**
     * 
     * 电子账簿 ID
     *
     * (必填)
     */
    @NotBlank
    private String balanceAcctId1;

    /**
     * 
     * 电子账簿 ID
     *
     * (必填)
     */
    @NotBlank
    private String balanceAcctId2;

    /**
     * 
     * 短信验证码
     * (选填)
     */
    private String code;

}