/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.fund;

import com.fshows.shande.sdk.request.ShandeRequest;
import com.fshows.shande.sdk.request.fund.item.ShandeTransferParamItemRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * 分账（批量转账）入参
 *
 * @author
 * @version ShandeFundAllocationsOutRequest.java, v 0.1 2022-12-06 10:11:52
 */
@Data
public class ShandeFundAllocationsOutRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555312935879L;


    /**
     * 平台订单号
     * 1、平台的唯一请求单号2、要求 64 个字符内，只能是数 字、大小写字母和_-
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

    /**
     * 发送时间
     * 格式: RFC3339
     * <p>
     * (选填)
     */
    @Length(max = 25, message = "sentAt长度不能超过25")
    private String sentAt;

    /**
     * 金额
     * 单位为分，要求不能带小数点
     * <p>
     * (必填)
     */
    @NotNull
    private Integer amount;

    /**
     * 付款电子账簿 ID
     * 付款用户的电子账簿ID
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "payBalanceAcctId长度不能超过19")
    private String payBalanceAcctId;

    /**
     * 分账参数
     * 分账明细
     * <p>
     * (必填)
     */
    @NotNull
    private List<ShandeTransferParamItemRequest> transferParams;

    /**
     * 备注
     * 备注信息
     * <p>
     * (选填)
     */
    @Length(max = 255, message = "remark长度不能超过255")
    private String remark;

    /**
     * 扩展字段
     * 预留扩展字段交易涉及的商品信息，根据必传要求上送，参考示例
     * extra[notify_url] 交易结果通知地址，用于接收异步通知地址的 URL
     * <p>
     * (特殊必填)
     */
    private Map<String, Object> extra;

    /**
     * 自定义参数
     * {"purpose":"123456"}
     * <p>
     * (选填)
     */
    private Map<String, String> metadata;

    /**
     * 鉴权验证是否通过短信发送
     * 默认不发送0：不发送1：发送
     * <p>
     * (选填)
     */
    @Length(max = 1, message = "isSendMsg长度不能超过1")
    private String isSendMsg;

}