/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.fund;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 充值订单查询入参
 *
 * @author
 * @version ShandeDepositsQueryInRequest.java, v 0.1 2022-12-06 14:58:38
 */
@Data
public class ShandeDepositsQueryInRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555892682539L;


    /**
     * 系统订单号
     * 系统订单号和平台订单号二选一
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "depositId长度不能超过19")
    private String depositId;

    /**
     * 平台订单号
     * 系统订单号和平台订单号二选一
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

}