/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.books;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 电子回单生成（查询）入参
 *
 * @author
 * @version ShandeElectronicReceiptsQueryRequest.java, v 0.1 2022-12-06 11:31:19
 */
@Data
public class ShandeElectronicReceiptsQueryRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555167624093L;


    /**
     * 交易的系统订单号
     * 
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "tradeId长度不能超过19")
    private String tradeId;

}