/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.books;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 电子账簿查询（用户 ID）入参
 *
 * @author
 * @version ShandeBookQueryByMchIdRequest.java, v 0.1 2022-12-05 20:13:56
 */
@Data
public class ShandeBookQueryByMchIdRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555658705555L;


    /**
     * 个人用户 ID
     * 进件成功返回的个人用户 ID 和二级商户 ID 选一填写
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "cusId长度不能超过19")
    private String cusId;

    /**
     * 二级商户 ID
     * 进件成功返回的二级商户 ID 和个人用户 ID 选一填写
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "mchId长度不能超过19")
    private String mchId;

}