package com.fshows.com.shande.openapi.sdk.util;

import com.alibaba.fastjson.JSONObject;
import com.fshows.com.shande.openapi.sdk.constant.RequestConstants;

/**
 * 序列号生成
 *
 * @author ZhangqiHao
 * @date 2018/12/5 16:15
 **/
public class SerialNoUtils {

    private static final int SERIAL_NO_MIN_LENGTH = 6;

    /**
     * 获取请求流水号
     *
     * @param data 请求参数
     * @return 流水号
     */
    public static String calculateSerialNo(String data) {
        String clintSerialNo = "";
        if (null != data) {
            JSONObject dataJO = JSONObject.parseObject(data);
            if (null != dataJO) {
                clintSerialNo = dataJO.getString(RequestConstants.RequestHeader.KEY_CLIENT_SERIAL_NO);
            }
        }
        if (null == clintSerialNo || clintSerialNo.isEmpty()) {
            clintSerialNo = "sn" + SnowflakeIdWorkerUtils.nextId();
        }
        isSerialNoAvailable(clintSerialNo);
        return clintSerialNo;
    }

    /**
     * 校验流水号
     *
     * @param serialNo 当前流水号
     */
    private static void isSerialNoAvailable(String serialNo) {
        if (null == serialNo || "".equals(serialNo)) {
            throw new IllegalArgumentException("the client_serial_no should not be empty");
        }

        if (serialNo.length() < SERIAL_NO_MIN_LENGTH) {
            throw new IllegalArgumentException("the length of client_serial_no is not allowed");
        }
    }
}
