package com.fshows.com.shande.openapi.sdk.client;

import com.fshows.com.shande.openapi.sdk.config.Configuration;
import com.fshows.com.shande.openapi.sdk.service.OpenApiCommonService;
import com.fshows.com.shande.openapi.sdk.service.OpenApiFileDownloadService;
import com.fshows.com.shande.openapi.sdk.service.OpenApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

/**
 * 衫德API请求客户端
 *
 * @author linzy
 * @date v 0.1 2022-12-02 16:19 linzy
 */
public class ShandeOpenApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShandeOpenApiClient.class);

    static {
        trustAllHttpsCertificates();
    }

    /**
     * 配置对象，商户根据接入需求实现具体配置
     */
    private Configuration configuration;

    public ShandeOpenApiClient(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return configuration;
    }

    /**
     * 运行时动态修改服务配置
     */
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    /**
     * 不校验服务端的证书（需要校验时可做处理）
     */
    private static void trustAllHttpsCertificates() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{new X509TrustManager() {
                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HostnameVerifier hv = new HostnameVerifier() {
                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return hostname.equalsIgnoreCase(session.getPeerHost());
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        } catch (NoSuchAlgorithmException | KeyManagementException e) {
            LOGGER.error("Invalid ssl for certs.", e);
        }
    }

    /**
     * API请求
     *
     * @param context 上下文
     */
    public String send(OpenParameters context) throws Exception {
        OpenApiService openApiService = new OpenApiCommonService();
        return openApiService.execute(this, context);
    }

    /**
     * 文件下载
     *
     * @param context 上下文
     */
    public String downloadFile(OpenParameters context) throws Exception {
        OpenApiService openApiService = new OpenApiFileDownloadService();
        return openApiService.execute(this, context);
    }

}
