/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.response.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 审核失败原因
 *
 * @author liluqing
 * @version ShandeEntryFailureMsgsResponse.java, v 0.1 2022-12-06 14:59
 */
@Data
public class ShandeEntryFailureMsgsResponse implements Serializable {

    private static final long serialVersionUID = -2213838555780648059L;

    /**
     * 审核失败参数
     * 审核失败的字段名称
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "param长度不能超过32")
    private String param;

    /**
     * 审核失败驳回原因
     * 审核失败字段的被驳回原因
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "reason长度不能超过64")
    private String reason;
}