/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.fund;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * 提现创建响应结果
 *
 * @author
 * @version ShandeFundWithdrawalsOutResponse.java, v 0.1 2022-12-06 09:06:57
 */
@Data
public class ShandeFundWithdrawalsOutResponse implements Serializable {

    private static final long serialVersionUID = -2213838555583230129L;


    /**
     * 系统订单号
     * 由系统生成的唯一单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "withdrawalId长度不能超过19")
    private String withdrawalId;

    /**
     * 平台订单号
     * 平台的唯一请求单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

    /**
     * 交易状态
     * processing: 处理中succeeded: 提现成功 failed: 失败
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "status长度不能超过10")
    private String status;

    /**
     * 原因描述
     * 失败或退汇时的具体错误原
     *
     * (特殊必填)
     */
    @Length(max = 200, message = "reason长度不能超过200")
    private String reason;

    /**
     * 创建时间
     * 提现创建时间，格式:RFC3339
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 25, message = "createdAt长度不能超过25")
    private String createdAt;

    /**
     * 完成时间
     * 提现完成时间，格式:RFC3339
     *
     * (特殊必填)
     */
    @Length(max = 25, message = "finishedAt长度不能超过25")
    private String finishedAt;

    /**
     * 金额
     * 单位为分，提现金额
     *
     * (必填)
     */
    @NotNull
    private Integer amount;

    /**
     * 平台手续费
     * 平台向平台下用户收取的交易手续费，不传为 0，单位为分
     *
     * (选填)
     */
    private Integer serviceFee;

    /**
     * 业务类型
     * 枚举值：1 - 提现 2 - 转账
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "businessType长度不能超过1")
    private String businessType;

    /**
     * 电子账簿 ID
     * 提现的电子账簿 ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 银行附言
     * 展示在收款银行系统中的附言
     *
     * (选填)
     */
    @Length(max = 30, message = "bankMemo长度不能超过30")
    private String bankMemo;

    /**
     * 备注
     * 备注信息
     *
     * (选填)
     */
    @Length(max = 255, message = "remark长度不能超过255")
    private String remark;

    /**
     * 扩展字段
     * 预留扩展字段
     * <p>
     * (选填)
     */
    private Map<String, Object> extra;

    /**
     * 自定义参数
     * {"purpose":"123456"}
     * <p>
     * (选填)
     */
    private Map<String, String> metadata;

}