/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.response.books.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 电子账簿信息
 *
 * @author liluqing
 * @version ShandeBalanceAcctsResponse.java, v 0.1 2022-12-06 10:33
 */
@Data
public class ShandeBalanceAcctsResponse implements Serializable {

    private static final long serialVersionUID = -2213838555834578039L;

    /**
     * 电子账簿 ID
     * 系统生成的唯一的电子账簿号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 电子账簿账簿号
     * 1、系统生成的电子账簿账簿号可作为收款信息，用于接收外部转账2、可能存在与用户 ID、电子账簿 ID、绑定账户 ID 无法同时生成的情况，需要再次通过查询接口获取
     *
     * (特殊必填)
     */
    @Length(max = 24, message = "relAcctNo长度不能超过24")
    private String relAcctNo;

    /**
     * 可提现余额
     * 单位分，可用于消费、提现操作
     *
     * (必填)
     */
    @NotNull
    private Integer settledAmount;

    /**
     * 可转账金额
     * 单位分。可用于消费、分账操作
     *
     * (必填)
     */
    @NotNull
    private Integer allocationAmount;

    /**
     * 在途余额
     * 单位分，在途余额，可用于消费操作
     *
     * (必填)
     */
    @NotNull
    private Integer pendingAmount;

    /**
     * 不可用余额
     * 单位分，不可用余额
     *
     * (必填)
     */
    @NotNull
    private Integer expensingAmount;

    /**
     * 冻结余额
     * 冻结余额，单位分。值为 0 时，不返回该字段。
     *
     * (特殊必填)
     */
    private Integer frozenSettledAmount;

    /**
     * 电子账簿类型
     * 电子账簿类型：basic: 电子账簿 charge: 挂帐账簿 fee: 平台手续费账簿 deposit: 充值账簿 withdrawal: 提现在途账簿guarantee: 担保账簿advance: 垫资账簿 marketing: 营销账簿 bank_fund: 银行存款账簿
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "acctType长度不能超过20")
    private String acctType;

    /**
     * 电子账簿是否被冻结
     * true: 已冻结false: 未冻结
     *
     * (必填)
     */
    @NotNull
    private Boolean isFrozen;

    /**
     * 备注
     * 备注信息
     *
     * (选填)
     */
    @Length(max = 255, message = "remark长度不能超过255")
    private String remark;

}