/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.books;

import com.fshows.shande.sdk.response.books.item.ShandeBalanceAcctsResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.List;

/**
 * 电子账簿查询（用户 ID）响应结果
 *
 * @author
 * @version ShandeBookQueryByMchIdResponse.java, v 0.1 2022-12-05 20:13:56
 */
@Data
public class ShandeBookQueryByMchIdResponse implements Serializable {

    private static final long serialVersionUID = -2213838555834578039L;


    /**
     * 电子账簿信息列表
     * 用户绑定的电子账簿列表
     *
     * (必填)
     */
    @NotNull
    private List<ShandeBalanceAcctsResponse> balanceAccts;

}