/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.books;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 新增电子账簿响应结果
 *
 * @author
 * @version ShandeAccountBookAddResponse.java, v 0.1 2022-12-05 19:49:52
 */
@Data
public class ShandeAccountBookAddResponse implements Serializable {

    private static final long serialVersionUID = -2213838555455494422L;


    /**
     * 平台订单号
     * 平台自定义的唯一编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

    /**
     * 个人用户 ID
     * 进件成功返回的个人用户 ID和二级商户 ID 选一填写
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "cusId长度不能超过19")
    private String cusId;

    /**
     * 二级商户 ID
     * 进件成功返回的二级商户 ID
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "mchId长度不能超过19")
    private String mchId;

    /**
     * 电子账簿 ID
     * 系统生成的电子账簿唯一 ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 电子账簿账簿号
     * 1、系统生成的电子账簿账簿号，可作为收款信息，用于接收外部转账2、可能存在与用户ID、电子账簿 ID、绑定账户 ID 无法同时生成的情况，需要再次通过查询接口获取
     *
     * (特殊必填)
     */
    @Length(max = 24, message = "relAcctNo长度不能超过24")
    private String relAcctNo;

}