/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 企业信息
 *
 * @author liluqing
 * @version ShandeBusinessInfoRequest.java, v 0.1 2022-12-06 14:33
 */
@Data
public class ShandeBusinessInfoRequest implements Serializable {

    private static final long serialVersionUID = -2213838555911708488L;

    /**
     * 企业分类大类
     * 参照：[企业行业类型编码]
     *
     * (选填)
     */
    @Length(max = 1, message = "type长度不能超过1")
    private String type;

    /**
     * 企业分类细分
     * 参照：[企业行业类型编码]
     *
     * (选填)
     */
    @Length(max = 5, message = "subType长度不能超过5")
    private String subType;

    /**
     * 企业经济成分
     * 参照：[企业经济成分]
     *
     * (选填)
     */
    @Length(max = 3, message = "economy长度不能超过3")
    private String economy;

    /**
     * 企业规模
     * 参照：[企业规模编码]
     *
     * (选填)
     */
    @Length(max = 4, message = "scale长度不能超过4")
    private String scale;

    /**
     * 企业经营范围
     * 经营范围
     *
     * (选填)
     */
    @Length(max = 128, message = "range长度不能超过128")
    private String range;

    /**
     * 企业经营地址
     * 经营地址
     *
     * (选填)
     */
    @Length(max = 128, message = "address长度不能超过128")
    private String address;

    /**
     * 企业注册资本
     * 注册资本平台业务参数配置(RMB/分)
     *
     * (选填)
     */
    private Integer registeredCapital;

    /**
     * 企业注册地电话号码
     * 注册地电话号码
     *
     * (选填)
     */
    @Length(max = 20, message = "registeredTel长度不能超过20")
    private String registeredTel;
}