/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 受益所有人信息
 *
 * @author liluqing
 * @version ShandeBeneficiaryIdCardRequest.java, v 0.1 2022-12-06 14:43
 */
@Data
public class ShandeBeneficiaryIdCardRequest  implements Serializable {

    private static final long serialVersionUID = -2213838555911708488L;

    /**
     * 受益所有人姓名
     *
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "name长度不能超过64")
    private String name;

    /**
     * 受益所有人证件类型
     * 受益所有人证件类型
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "type长度不能超过64")
    private String type;

    /**
     * 受益所有人证件号码
     *
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "number长度不能超过64")
    private String number;

    /**
     * 受益所有人证件有效期限
     * 受益所有人证件有效期限
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "validTime长度不能超过64")
    private String validTime;

    /**
     * 受益所有人证件影像件人像面（身份证）
     * 受益所有人证件影像件
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "copy长度不能超过64")
    private String copy;

    /**
     * 受益所有人证件影像件国徽面（身份证）
     * 受益所有人证件影像件（身份证有此项）
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "national长度不能超过64")
    private String national;
}