/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.fund;

import com.fshows.shande.sdk.request.ShandeRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 分账（批量转账）订单查询入参
 *
 * @author
 * @version ShandeFundAllocationsQueryOutRequest.java, v 0.1 2022-12-06 11:25:15
 */
@Data
public class ShandeFundAllocationsQueryOutRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555923476681L;


    /**
     * 系统订单号
     * 系统订单号和平台订单号二选一
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "allocationId长度不能超过19")
    private String allocationId;

    /**
     * 平台订单号
     * 系统订单号和平台订单号二选一
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

}