/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.books;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 电子账簿查询（电子账簿 ID）入参
 *
 * @author
 * @version ShandeBookQueryByBookidRequest.java, v 0.1 2022-12-05 19:41:13
 */
@Data
public class ShandeBookQueryByBookidRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555942550039L;


    /**
     * 电子账簿ID
     * 系统生成的电子账簿唯一 ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

}