/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.account;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Map;

import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 新增绑定账户入参
 *
 * @author
 * @version ShandeAccountAddBindingRequest.java, v 0.1 2022-12-06 13:59:03
 */
@Data
public class ShandeAccountAddBindingRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555638548678L;


    /**
     * 平台订单号
     * 1、平台自定义的唯一编号2、每个平台订单号对应一个系统订单号，每个系统订单号进件通过后会生成一个绑定账户编号3、若绑定账户验证失败，可填写相同的“平台订单号”，即可覆盖修改原申请单信息4、要求 64 个字符内，只能是数字、大小写字母和_-
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

    /**
     * 个人用户 ID
     * 进件成功返回的个人用户 ID和二级商户 ID 选一填写
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "cusId长度不能超过19")
    private String cusId;

    /**
     * 二级商户 ID
     * 进件成功返回的二级商户 ID和个人用户 ID 选一填写
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "mchId长度不能超过19")
    private String mchId;

    /**
     * 银行账户类型
     * 根据主体类型，可选择的账户类型如下：
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "bankAcctType长度不能超过1")
    private String bankAcctType;

    /**
     * 开户银行编码
     * 1、若账户类型为 1 - 对私账户时，非必传2、若账户类型为 2 - 对公账户时，必传3、详细参见[开户银行联行号表]drec_code  字段
     *
     * (特殊必填)
     */
    @Length(max = 12, message = "bankCode长度不能超过12")
    private String bankCode;

    /**
     * 开户银行省市编码
     * 至少精确到市，详细参见：[省市区编号对照表]
     *
     * (选填)
     */
    @Length(max = 6, message = "bankAddressCode长度不能超过6")
    private String bankAddressCode;

    /**
     * 开户银行联行号
     * 1、若账户类型为 1 - 对私账户时，非必传2、若账户类型为 2 - 对公账户时，必传详细参见：[开户银行联行号表]bank_code 字段
     *
     * (特殊必填)
     */
    @Length(max = 12, message = "bankBranchCode长度不能超过12")
    private String bankBranchCode;

    /**
     * 银行账号
     * 
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 34, message = "bankAcctNo长度不能超过34")
    private String bankAcctNo;

    /**
     * 职业
     * 详细参见：[职业信息表]
     *
     * (选填)
     */
    @Length(max = 5, message = "profession长度不能超过5")
    private String profession;

    /**
     * 绑定的手机号
     * 1、银行卡预留的手机号，不填默认取当前用户信息中的手机号
     *
     * (选填)
     */
    @Length(max = 20, message = "mobileNumber长度不能超过20")
    private String mobileNumber;

    /**
     * 短信验证码
     * 1、通过[个人手机号验证码]接口获取的短信验证码，用于验证法人手机号2、银行账户类型为对公银行账户时选传，为对私银行卡类型时必传
     *
     * (特殊必填)
     */
    @Length(max = 6, message = "smsCode长度不能超过6")
    private String smsCode;

    /**
     * 自定义参数
     * {"description":"123456"}
     *
     * (选填)
     */
    private Map<String, String> metadata;

    /**
     * 额外信息
     * 按管理后台配置情况填写
     *
     * 可设置参数：
     * authType - 按管理后台配置情况填写二级商户可选 1: 小额打款个人用户可选2: 二要素鉴权;3: 三要素鉴权;4: 四要素鉴权
     *
     * (选填)
     */
    private Map<String, Object> extra;


}