/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.shande.sdk.common;

import java.text.MessageFormat;

/**
 * 衫德异常
 *
 * @author linzy
 * @version ShandeException.java, v 0.1 2022-12-02 09:46 linzy
 * @date 2020/10/16
 */
public class ShandeException extends RuntimeException {

    /**
     * 服务器异常
     */
    public static final ShandeException SERVER_EXCEPTION = new ShandeException("SERVER_ERROR", "调用衫德接口服务异常");
    /**
     * 业务异常
     */
    public static final ShandeException BUSINESS_EXCEPTION = new ShandeException("BUSINESS_ERROR", "调用衫德接口业务异常");
    protected String msg;
    protected String code;

    public ShandeException(String code, String msgFormat, Object... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.msg = MessageFormat.format(msgFormat, args);
    }


    public ShandeException() {
    }

    public ShandeException(String message, Throwable cause) {
        super(message, cause);
    }

    public ShandeException(Throwable cause) {
        super(cause);
    }

    public ShandeException(String message) {
        super(message);
    }


    public ShandeException newInstance(String msgFormat, Object... args) {
        return new ShandeException(this.code, MessageFormat.format(msgFormat, args));
    }


    public String getMsg() {
        return this.msg;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public String getMessage() {
        return "[" + this.code + "]" + this.msg;
    }
}


