/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.shande.sdk.common;


import com.fshows.shande.sdk.request.account.ShandeAccountAddBindingRequest;
import com.fshows.shande.sdk.request.account.ShandeAccountDeleteBindingRequest;
import com.fshows.shande.sdk.request.account.ShandeAccountQueryBindingRequest;
import com.fshows.shande.sdk.request.books.ShandeAccountBookAddRequest;
import com.fshows.shande.sdk.request.books.ShandeBalanceTransactionsRequest;
import com.fshows.shande.sdk.request.books.ShandeBookQueryByBookidRequest;
import com.fshows.shande.sdk.request.books.ShandeBookQueryByMchIdRequest;
import com.fshows.shande.sdk.request.books.ShandeElectronicReceiptsQueryRequest;
import com.fshows.shande.sdk.request.books.ShandeSettleValidateRequest;
import com.fshows.shande.sdk.request.common.ShandeAcctPasswordsRequest;
import com.fshows.shande.sdk.request.common.ShandePersonalValidationSmsRequest;
import com.fshows.shande.sdk.request.common.ShandeUploadImageRequest;
import com.fshows.shande.sdk.request.fund.ShandeDepositsInRequest;
import com.fshows.shande.sdk.request.fund.ShandeDepositsQueryInRequest;
import com.fshows.shande.sdk.request.fund.ShandeFundAllocationsOutRequest;
import com.fshows.shande.sdk.request.fund.ShandeFundAllocationsQueryOutRequest;
import com.fshows.shande.sdk.request.fund.ShandeFundBalancePaymentsAddOutRequest;
import com.fshows.shande.sdk.request.fund.ShandeFundBalancePaymentsDeleteOutRequest;
import com.fshows.shande.sdk.request.fund.ShandeFundBalancePaymentsQueryOutRequest;
import com.fshows.shande.sdk.request.fund.ShandeFundBalancePaymentsSmsCodeOutRequest;
import com.fshows.shande.sdk.request.fund.ShandeFundPaymentsOutQueryRequest;
import com.fshows.shande.sdk.request.fund.ShandeFundPaymentsOutRequest;
import com.fshows.shande.sdk.request.fund.ShandeFundWithdrawalsOutRequest;
import com.fshows.shande.sdk.request.fund.ShandeFundWithdrawalsQueryRequest;
import com.fshows.shande.sdk.request.merchant.ShandeApplicationsQueryRequest;
import com.fshows.shande.sdk.request.merchant.ShandeApplicationsSubmchAddRequest;
import com.fshows.shande.sdk.request.merchant.ShandeApplicationsSubmchQueryRequest;
import com.fshows.shande.sdk.request.merchant.ShandeApplicationsSubmchUpdateRequest;
import com.fshows.shande.sdk.request.merchant.ShandeCusApplicationsOpenRequest;
import com.fshows.shande.sdk.request.merchant.ShandeCusApplicationsQueryRequest;
import com.fshows.shande.sdk.request.merchant.ShandeCusApplicationsRenewRequest;
import com.fshows.shande.sdk.response.account.ShandeAccountAddBindingResponse;
import com.fshows.shande.sdk.response.account.ShandeAccountDeleteBindingResponse;
import com.fshows.shande.sdk.response.account.ShandeAccountQueryBindingResponse;
import com.fshows.shande.sdk.response.books.ShandeAccountBookAddResponse;
import com.fshows.shande.sdk.response.books.ShandeBalanceTransactionsResponse;
import com.fshows.shande.sdk.response.books.ShandeBookQueryByBookidResponse;
import com.fshows.shande.sdk.response.books.ShandeBookQueryByMchIdResponse;
import com.fshows.shande.sdk.response.books.ShandeElectronicReceiptsQueryResponse;
import com.fshows.shande.sdk.response.books.ShandeSettleValidateResponse;
import com.fshows.shande.sdk.response.common.ShandeAcctPasswordsResponse;
import com.fshows.shande.sdk.response.common.ShandePersonalValidationSmsResponse;
import com.fshows.shande.sdk.response.common.ShandeUploadImageResponse;
import com.fshows.shande.sdk.response.fund.ShandeDepositsInResponse;
import com.fshows.shande.sdk.response.fund.ShandeDepositsQueryInResponse;
import com.fshows.shande.sdk.response.fund.ShandeFundAllocationsOutResponse;
import com.fshows.shande.sdk.response.fund.ShandeFundAllocationsQueryOutResponse;
import com.fshows.shande.sdk.response.fund.ShandeFundBalancePaymentsAddOutResponse;
import com.fshows.shande.sdk.response.fund.ShandeFundBalancePaymentsDeleteOutResponse;
import com.fshows.shande.sdk.response.fund.ShandeFundBalancePaymentsQueryOutResponse;
import com.fshows.shande.sdk.response.fund.ShandeFundBalancePaymentsSmsCodeOutResponse;
import com.fshows.shande.sdk.response.fund.ShandeFundPaymentsOutResponse;
import com.fshows.shande.sdk.response.fund.ShandeFundPaymentsQueryOutResponse;
import com.fshows.shande.sdk.response.fund.ShandeFundWithdrawalsOutResponse;
import com.fshows.shande.sdk.response.fund.ShandeFundWithdrawalsQueryOutResponse;
import com.fshows.shande.sdk.response.merchant.ShandeApplicationsQueryResponse;
import com.fshows.shande.sdk.response.merchant.ShandeApplicationsSubmchAddResponse;
import com.fshows.shande.sdk.response.merchant.ShandeApplicationsSubmchQueryResponse;
import com.fshows.shande.sdk.response.merchant.ShandeApplicationsSubmchUpdateResponse;
import com.fshows.shande.sdk.response.merchant.ShandeCusApplicationsOpenResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * shande api 枚举
 *
 * @author linzy
 * @version ShandeApiEnum.java, v 0.1 2022-12-02 10:33 linzy
 */
public enum ShandeApiEnum {
    /**
     * 进件相关
     */
    CUS_OPEN("个人用户进件",
            "/merchant/cus_applications_open", ShandeCusApplicationsOpenRequest.class, ShandeCusApplicationsOpenResponse.class),
    CUS_QUERY("个人用户进件状态查询",
            "/merchant/cus_applications_query", ShandeCusApplicationsQueryRequest.class, ShandeCusApplicationsOpenResponse.class),
    CUS_APPLICATIONS_RENEW("个人用户信息修改",
            "/merchant/cus_applications_renew", ShandeCusApplicationsRenewRequest.class, ShandeCusApplicationsOpenResponse.class),
    APPLICATIONS_QUERY("查询用户或二级商户是否进件(申请单查询)",
            "/merchant/applications_query", ShandeApplicationsQueryRequest.class, ShandeApplicationsQueryResponse.class),
    APPLICATIONS_SUBMCH_ADD("二级商户（企业用户）进件",
            "/merchant/mch_applications_open", ShandeApplicationsSubmchAddRequest.class, ShandeApplicationsSubmchAddResponse.class),
    APPLICATIONS_SUBMCH_UPDATE("二级商户信息修改",
            "/merchant/mch_applications_renew", ShandeApplicationsSubmchUpdateRequest.class, ShandeApplicationsSubmchUpdateResponse.class),
    APPLICATIONS_SUBMCH_QUERY("二级商户进件状态查询",
            "/merchant/mch_applications_query", ShandeApplicationsSubmchQueryRequest.class, ShandeApplicationsSubmchQueryResponse.class),


    /**
     * 账户相关
     */
    ACCOUNT_DELETE_BINDING("删除绑定账户",
            "/merchant/delete_settle_accts", ShandeAccountDeleteBindingRequest.class, ShandeAccountDeleteBindingResponse.class),
    ACCOUNT_QUERY_BINDING("查询绑定账户",
            "/merchant/settle_accts_query", ShandeAccountQueryBindingRequest.class, ShandeAccountQueryBindingResponse.class),
    ACCOUNT_ADD_BINDING("新增绑定账户",
            "/merchant/add_settle_accts", ShandeAccountAddBindingRequest.class, ShandeAccountAddBindingResponse.class),

    /**
     * 电子账簿相关api
     */
    ACCOUNT_BOOKS_ADD("新增电子账簿",
            "/merchant/balance_accts", ShandeAccountBookAddRequest.class, ShandeAccountBookAddResponse.class),
    ACCOUNT_BOOKS_QUERY_BY_BOOKID("电子账簿查询（电子账簿 ID）",
            "/merchant/balance_accts_query", ShandeBookQueryByBookidRequest.class, ShandeBookQueryByBookidResponse.class),
    ACCOUNT_BOOKS_QUERY_BY_MERCHANTNO("电子账簿查询（用户 ID）",
            "/merchant/balance_accts_query", ShandeBookQueryByMchIdRequest.class, ShandeBookQueryByMchIdResponse.class),
    SETTLE_ACCTS_VALIDATE("打款验证（绑定账户编码）",
            "/merchant/settle_accts_validate", ShandeSettleValidateRequest.class, ShandeSettleValidateResponse.class),
    ELECTRONIC_RECEIPTS_QUERY("电子回单生成（查询）",
            "/merchant/electronic_receipts_query", ShandeElectronicReceiptsQueryRequest.class, ShandeElectronicReceiptsQueryResponse.class),
    BALANCE_TRANSACTIONS("电子账簿流水查询",
            "/merchant/balance_transactions", ShandeBalanceTransactionsRequest.class, ShandeBalanceTransactionsResponse.class),


    /**
     * 其他
     */
    PERSONAL_VALIDATION_SMS("个人用户手机号验证",
            "/merchant/personal_validation_sms_codes", ShandePersonalValidationSmsRequest.class, ShandePersonalValidationSmsResponse.class),
    UPLOAD_IMAGE("上传图片",
            "/merchant/uploadimage", ShandeUploadImageRequest.class, ShandeUploadImageResponse.class),
    ACCT_PASSWORDS("中台监管账户交易密码",
            "/merchant/acct_passwords", ShandeAcctPasswordsRequest.class, ShandeAcctPasswordsResponse.class),


    /**
     * 交易入金类相关api
     */
    FUND_IN_DEPOSITS("支付充值",
            "/in/deposits", ShandeDepositsInRequest.class, ShandeDepositsInResponse.class),
    FUND_IN_DEPOSITS_QUERY("充值订单查询",
            "/in/deposits_query", ShandeDepositsQueryInRequest.class, ShandeDepositsQueryInResponse.class),

    /**
     * 交易出金类相关api
     */
    FUND_OUT_WITHDRAWALS("提现创建",
            "/out/withdrawals", ShandeFundWithdrawalsOutRequest.class, ShandeFundWithdrawalsOutResponse.class),
    FUND_OUT_WITHDRAWALS_QUERY("提现订单查询",
            "/out/withdrawals_query", ShandeFundWithdrawalsQueryRequest.class, ShandeFundWithdrawalsQueryOutResponse.class),
    FUND_OUT_PAYMENTS("消费（转账）",
            "/out/payments", ShandeFundPaymentsOutRequest.class, ShandeFundPaymentsOutResponse.class),
    FUND_OUT_PAYMENTS_QUERY("消费（转账）订单查询",
            "/out/payments_query", ShandeFundPaymentsOutQueryRequest.class, ShandeFundPaymentsQueryOutResponse.class),
    FUND_OUT_BALANCE_PAYMENTS_ADD("配置电子账簿关联关系",
            "/out/balance_payments_add", ShandeFundBalancePaymentsAddOutRequest.class, ShandeFundBalancePaymentsAddOutResponse.class),
    FUND_OUT_BALANCE_PAYMENTS_QUERY("查询可以转账的电子账簿",
            "/out/balance_payments_query", ShandeFundBalancePaymentsQueryOutRequest.class, ShandeFundBalancePaymentsQueryOutResponse.class),
    FUND_OUT_BALANCE_PAYMENTS_DELETE("删除电子账簿关联关系",
            "/out/balance_payments_delete", ShandeFundBalancePaymentsDeleteOutRequest.class, ShandeFundBalancePaymentsDeleteOutResponse.class),
    FUND_OUT_BALANCE_PAYMENTS_SMS_CODE("获取新增电子账簿短信验证码",
            "/out/balance_payments_sms_code", ShandeFundBalancePaymentsSmsCodeOutRequest.class, ShandeFundBalancePaymentsSmsCodeOutResponse.class),
    FUND_OUT_ALLOCATIONS("分账（批量转账）",
            "/out/allocations", ShandeFundAllocationsOutRequest.class, ShandeFundAllocationsOutResponse.class),
    FUND_OUT_ALLOCATIONS_QUERY("分账（批量转账）订单查询",
            "/out/allocations_query", ShandeFundAllocationsQueryOutRequest.class, ShandeFundAllocationsQueryOutResponse.class),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口子路径
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    ShandeApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static ShandeApiEnum getByValue(String value) {
        ShandeApiEnum[] valueList = ShandeApiEnum.values();
        for (ShandeApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}
