package com.fshows.com.shande.openapi.sdk.crypto;

import com.fshows.com.shande.openapi.sdk.config.Configuration;
import com.fshows.com.shande.openapi.sdk.constant.AlgorithmTypeEnum;
import com.fshows.com.shande.openapi.sdk.util.RSAUtils;

import java.nio.charset.StandardCharsets;

/**
 * RSA硬件验签策略,RSA加解密
 *
 * @author tangjunmao
 * @date 2018/10/22
 */
public class RSACryptoWithHardwareStrategy extends RSACryptoEncryptionService implements CryptoSignatureService {
    @Override
    public String signature(String data, Configuration configuration) throws Exception {
        return RSAUtils.detachSign(data.getBytes(StandardCharsets.UTF_8), configuration);
    }

    @Override
    public boolean verifySignature(String data, String signature, String publicKey) throws Exception {
        return RSAUtils.verifySignature(data, signature, publicKey);
    }

    @Override
    public String getAlgorithmType() {
        return AlgorithmTypeEnum.RSA_HARDWARE.getAlgorithmType();
    }
}
