package com.fshows.com.shande.openapi.sdk.crypto;

import com.fshows.com.shande.openapi.sdk.config.Configuration;

/**
 * 签名验签服务
 *
 * @author miwenming
 * @date 2020/5/21 11:29
 */
public interface CryptoSignatureService extends AlgorithmService {

    /**
     * 用私钥指定字符串签名
     *
     * @param data          需要签名的字符串
     * @param configuration 配置类
     */
    String signature(String data, Configuration configuration) throws Exception;

    /**
     * 用公钥对签名进行验证
     *
     * @param data 需要签名验证的字符串
     * @param signature 签名值
     * @param publicKey 公钥字符串
     */
    boolean verifySignature(String data, String signature, String publicKey) throws Exception;

}
