package com.fshows.com.shande.openapi.sdk.client;

import java.io.Serializable;

/**
 * 请求业务接口的配置
 *
 * @author linzy
 * @version OpenParameters.java, v 0.1 2022-12-02 13:42 linzy
 * @date 2022/12/02
 */
public final class OpenParameters implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 服务名称标识
     */
    private String apiName;
    /**
     * 请求业务报文体json字符串
     */
    private String params;

    private String fileName;

    private OpenParameters(Builder builder) {
        this.apiName = builder.apiName;
        this.params = builder.param;
        this.fileName = builder.fileName;
    }

    public String getApiName() {
        return apiName;
    }

    public String getParams() {
        return params;
    }

    public String getFileName() {
        return fileName;
    }

    /**
     * builder for all our params
     */
    public static class Builder {
        private String apiName;
        private String param;
        private String fileName;

        public Builder() {
            // empty
        }

        public Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public Builder param(String param) {
            this.param = param;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }


        public OpenParameters build() {
            return new OpenParameters(this);
        }
    }

}
