/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.postar.response.PostarBizRes;
import com.fshows.postar.response.trade.detail.AcqAddnData;
import com.fshows.postar.response.trade.detail.CouponGoodsInfo;
import com.fshows.postar.response.trade.detail.PromotionDetail;
import lombok.Data;

import java.util.List;

/**
 * @author wangqilei
 * @version PostarOrderQueryRes.java, v 0.1 2024-06-05 5:51 PM wangqilei
 */
@Data
public class PostarOrderQueryRes extends PostarBizRes {
    private static final long serialVersionUID = -8424758196753423534L;
    /**
     * 商户实收金额
     * 单位分，原订单交易金额-官方商户出资金额-商户交易实收手续费
     * (必填)
     */
    private String netrAmt;

    /**
     * 原订单交易金额
     * 单位分，对应下单接口txamt
     * (必填)
     */
    private String txamt;

    /**
     * 商户交易实收手续费
     * 单位分，成功时返回
     * (必填)
     */
    private String custFee;
    /**
     * 官方商户出资金额
     * 单位分，成功时返回，数币交易返回官方优惠金额，该字段809商户交易不返回
     * (必填)
     */
    private String custAmt;

    /**
     * 补贴类型
     * 0无、1机构补贴、2公司补贴、11落地机构补贴
     * (必填)
     */
    private String discountFlag;

    /**
     * 优惠手续费
     * 优惠手续费=应收手续费-实收手续费
     * (必填)
     */
    private String discountFee;

    /**
     * 国通平台订单号
     * 国通平台订单号，可用于退款
     * (必填)
     */
    private String orderNo;

    /**
     * 第三方订单号
     * 合作方订单号
     * (必填)
     */
    private String threeOrderNo;

    /**
     * 官方支付平台单号,目的通道流水
     * 微信/支付宝（目的通道流水号），银联（官方订单号）可用于退款
     * (必填)
     */
    private String torderNo;

    /**
     * 支付通道官方订单号
     * 微信、支付宝官方通道订单号
     * (必填)
     */
    private String payNo;

    /**
     * 订单完成时间（成功时返回）
     * (必填)
     */
    private String orderTime;

    /**
     * 支付方式
     * 0银联主扫 1支付宝主扫 2微信主扫 3付款码支付(银联被扫) 5公众号支付(微信被扫)
     * 7服务窗支付(支付宝被扫）8小程序普通交易（成功时返回）60数币B扫C 61数币被扫（C扫B）
     * (必填)
     */
    private String payWay;

    /**
     * 卡类型
     * 01借记卡、 02贷记卡、03其他
     * (必填)
     */
    private String cardType;

    /**
     * 机构编号
     * (必填)
     */
    private String agetId;

    /**
     * 消费者OPEN_ID
     * 成功时返回
     * (必填)
     */
    private String openId;

    /**
     * 消费者IP
     * 成功时返回
     * (必填)
     */
    private String tradingIp;

    /**
     * 交易手续费补贴金额
     * 单位 分
     */
    private String limitFee;

    /**
     * 花呗分期
     * 花呗分期数，当前仅支持3、6、12
     */
    private String hbFqNum;

    /**
     * 信用卡分期
     * 信用卡分期数，当前仅支持3、6、12
     */
    private String crFqNum;

    /**
     * 银行英文缩写
     * (选填)
     */
    private String bankCode;

    /**
     * 银行名称
     * (选填)
     */
    private String bankName;

    /**
     * 支付宝,微信单品优惠
     */
    @JSONField(name = "promotion_detail")
    private List<PromotionDetail> promotionDetailList;

    /**
     * 银联单品优惠
     */
    private AcqAddnData acqAddnData;

    /**
     * 子交易状态
     * 0：支付失败、1：支付成功、2：支付中、3：退款失败、4：退款成功、5：退款中、
     * 7：刷撤销成功、8：撤销失败、9：冲正、a：担保成功、b：担保撤销中、c：担保撤销成功、
     * e：数币成功、f：数币退款中、14：预授权成功、15：预授权撤销中、16：预授权撤销成功、
     * 98：刷卡撤销中、99：超时、i：通联支付成功、j：通联退款中、k：通联退款成功
     */
    private String orderStatus;

    /**
     * 官方出资金额
     */
    private String wxAgetSubsidy;

    /**
     * 其他出资
     */
    private String otherAmt;

    /**
     * 京东白条分期数
     * 当前仅支持3、6、12
     */
    private String jdbtFqNum;

    /**
     * 支付通道
     * 1：支付宝、2：微信支付、9：银联扫码、11：刷卡、12：数币、31：京东白条
     */
    private String payChannel;

    /**
     * 通道商户号
     */
    private String mercId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 刷卡参考号
     * payChannel为11才有该字段
     */
    private String srefNo;

    /**
     * 刷卡批次号
     * payChannel为11才有该字段
     */
    private String batNo;

    /**
     * 刷卡卡类型
     * 01：芯片卡、02：磁条卡。payChannel为11且非历史订单才有该字段
     */
    private String mediatype;

    /**
     * 刷卡双免标识
     * 0或者空代表不是，1代表是
     */
    private String txnRsv1;

    /**
     * 原国通订单号
     */
    private String oldOrderNo;

    /**
     * 交易类型
     * 01：扫码消费、02：刷卡消费、03：数币消费
     */
    private String tranTypeSer;

    /**
     * 设备号
     */
    private String deviceNo;

    /**
     * 子公众号消费者openid
     */
    private String subOpenId;

    /**
     * 优惠券编号
     */
    private String disInfo;

    /**
     * 优惠券实际优惠金额
     * 单位分
     */
    private String disTxamt;

    /**
     * 优惠券面额
     * 单位分
     */
    private String codeAmt;

    /**
     * 终端编号
     */
    private String terno;

    /**
     * 消费者实际支付金额
     * 单位分
     */
    private String actualPayAmt;

    /**
     * 通道异常信息
     */
    private String payErrorMsg;

    /**
     * 清算日期
     */
    private String ustlDat;

    /**
     * 京东保留数据
     */
    private String resvData;

    /**
     * 订单业务类型
     * 01：国补订单、02：万事达营销、03：服务化生码、11：管控流水冻结、
     * 12：管控流水解冻、13：冻结流水退款、14：解冻流水退款
     */
    private String orderType;

    /**
     * 网络服务费
     * 单位分
     */
    private String termFee;

    /**
     * 商户所属机构号
     */
    private String ageCustId;

    /**
     * 刷卡外卡优惠标识
     * 01：优惠、02：非优惠、03：DCC、04：万事达商务卡、05：运通外卡高扣率
     */
    private String wkTxnFlag;

    /**
     * 支付宝优惠信息
     */
    private String voucherDetailList;

    /**
     * 实时手续费标识
     * 01:不实时返回手续费、其余：实时返回
     */
    private String feeState;

    /**
     * 刷卡国别标识
     * 01:内卡、02:外卡
     */
    private String area;

    /**
     * 支付宝资金渠道
     */
    private String fundBillList;

    /**
     * 国补订单信息
     */
    private CouponGoodsInfo couponGoodsInfo;

    /**
     * 刷卡流水号（凭证号）
     */
    private String posVoucherno;
}